/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.controleurs;

import fr.asip.cps3.exemple.controleurs.MenuControleur;
import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionControleur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSignatureFichier;
import fr.asip.cps3.exemple.modele.resultats.ResultatSignatureMessage;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.empreintes.GenererEmpreinteFichier;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.empreintes.GenererEmpreinteMessage;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.generationaleatoire.GenerationSeed;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.CreerObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.ModificationAttributObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.Authentifier;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.signature.GenererSignatureFichier;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.signature.GenererSignatureMessage;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InitPIN;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.ModifPIN;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.verifications.VerifierSignatureFichier;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.verifications.VerifierSignatureMessage;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie1PIN;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie2PIN;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie3PIN;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieFichier;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieFichierSignature;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieFiltreObjet;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieMessage;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieMessageSignature;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieObjet;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieSeed;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcranControleur {
    private static Logger log = Logger.getLogger(EcranControleur.class);

    public static void executeOperation(Application application, Saisie saisie) {
        if (application != null && saisie != null) {
            try {
                switch (saisie.getType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        EcranControleur.executeOperationP11Sessions(application, saisie);
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        EcranControleur.executeOperationP11Objets(application, saisie);
                        break;
                    }
                    case 6: 
                    case 7: {
                        EcranControleur.executeOperationP11Empreintes(application, saisie);
                        break;
                    }
                    case 8: 
                    case 9: {
                        EcranControleur.executeOperationP11Signatures(application, saisie);
                        break;
                    }
                    case 10: 
                    case 11: {
                        EcranControleur.executeOperationP11Verifications(application, saisie);
                        break;
                    }
                    case 5: {
                        EcranControleur.executeOperationP11GenerationAleatoire(application, saisie);
                        break;
                    }
                    default: {
                        log.error((Object)"Type d'\u00e9cran inconnu");
                        throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
                    }
                }
                application.declencheMAJMenus();
            }
            catch (ExceptionProgrammeExemple exceptionProgrammeExemple) {
                application.notifieException(exceptionProgrammeExemple);
            }
            catch (Throwable throwable) {
                log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
            }
        } else {
            log.error((Object)"L'application et/ou l'\u00e9cran de saisie est nul");
            if (application != null) {
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
            }
        }
    }

    public static Vector<String> valideSaisie(Application application, Saisie saisie) {
        Vector<String> vector = new Vector<String>();
        if (application != null && saisie != null) {
            try {
                switch (saisie.getType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return EcranControleur.valideSaisieP11Sessions(application, saisie);
                    }
                    case 12: 
                    case 13: {
                        return EcranControleur.valideSaisieP11Objets(application, saisie);
                    }
                    case 6: 
                    case 7: {
                        return EcranControleur.valideSaisieP11Empreintes(application, saisie);
                    }
                    case 8: 
                    case 9: {
                        return EcranControleur.valideSaisieP11Signatures(application, saisie);
                    }
                    case 10: 
                    case 11: {
                        return EcranControleur.valideSaisieP11Verifications(application, saisie);
                    }
                    case 5: {
                        return EcranControleur.valideSaisieP11GenerationAleatoire(application, saisie);
                    }
                }
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
            catch (ExceptionProgrammeExemple exceptionProgrammeExemple) {
                application.notifieException(exceptionProgrammeExemple);
            }
            catch (Throwable throwable) {
                log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
            }
        } else {
            log.error((Object)"L'application et/ou l'\u00e9cran de saisie est nul");
            if (application != null) {
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
            }
        }
        return vector;
    }

    private static void executeOperationP11Sessions(Application application, Saisie saisie) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        switch (saisie.getType()) {
            case 3: {
                if (application.getSessionCourante() != null && ((Saisie2PIN)saisie).getPIN() != null && ((Saisie2PIN)saisie).getPIN2() != null && new String(((Saisie2PIN)saisie).getPIN()).equalsIgnoreCase(new String(((Saisie2PIN)saisie).getPIN2()))) {
                    resultat = InitPIN.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((Saisie2PIN)saisie).getPIN());
                    if (resultat == null) break;
                    application.declencheAffichageResultat(resultat);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de l'initialisation du code porteur");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 4: {
                if (application.getSessionCourante() != null && ((Saisie3PIN)saisie).getPIN() != null && ((Saisie3PIN)saisie).getPIN2() != null && new String(((Saisie3PIN)saisie).getPIN2()).equalsIgnoreCase(new String(((Saisie3PIN)saisie).getPIN3()))) {
                    resultat = ModifPIN.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((Saisie3PIN)saisie).getPIN(), ((Saisie3PIN)saisie).getPIN2());
                    if (resultat == null) break;
                    application.declencheAffichageResultat(resultat);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la modification du code porteur");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 2: {
                if (application.getSessionCourante() != null && ((Saisie1PIN)saisie).getPIN() != null) {
                    resultat = Authentifier.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((Saisie1PIN)saisie).getPIN(), false);
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat == null || resultat.getCodeRetourStr() == null || !resultat.getCodeRetourStr().startsWith("CKR_OK")) break;
                    application.getSessionCourante().chargeInfo(application.getLibrairieP11());
                    MenuControleur.refresh(application, "0,2,4,0");
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de l'authentification de l'utilisateur");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 1: {
                if (application.getSessionCourante() != null && ((Saisie1PIN)saisie).getPIN() != null) {
                    resultat = Authentifier.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((Saisie1PIN)saisie).getPIN(), true);
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat == null || resultat.getCodeRetourStr() == null || !resultat.getCodeRetourStr().startsWith("CKR_OK")) break;
                    application.getSessionCourante().chargeInfo(application.getLibrairieP11());
                    MenuControleur.refresh(application, "0,2,4,1");
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de l'authentification du Security Officer (SO)");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
    }

    private static void executeOperationP11Objets(Application application, Saisie saisie) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        switch (saisie.getType()) {
            case 12: {
                if (application.getSessionCourante() != null && ((SaisieObjet)saisie).getLibelleObjet() != null && ((SaisieObjet)saisie).getObjet() != null) {
                    resultat = CreerObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieObjet)saisie).getLibelleObjet(), ((SaisieObjet)saisie).getObjet());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat == null || resultat.getCodeRetourStr() == null || !resultat.getCodeRetourStr().startsWith("CKR_OK")) break;
                    TraitementsUtil.rechercheObjets(application, 4, ((SaisieObjet)saisie).getLibelleObjet(), false);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de creation de l'objet");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 13: {
                if (application.getSessionCourante() != null && ((SaisieObjet)saisie).getLibelleObjet() != null && ((SaisieObjet)saisie).getObjet() != null) {
                    resultat = ModificationAttributObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieObjet)saisie).getIdObjet(), ((SaisieObjet)saisie).getLibelleObjet(), ((SaisieObjet)saisie).getObjet());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat == null || resultat.getCodeRetourStr() == null || !resultat.getCodeRetourStr().startsWith("CKR_OK")) break;
                    TraitementsUtil.rechercheObjets(application, 4, ((SaisieObjet)saisie).getLibelleObjet(), false);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de modification de l'objet");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 14: {
                if (application.getSessionCourante() != null) {
                    application.supprimeTousLesFiltresObjets();
                    resultat = TraitementsUtil.rechercheObjets(application, 4, ((SaisieFiltreObjet)saisie).getFiltre(), true);
                    if (resultat == null) break;
                    application.declencheAffichageResultat(resultat);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de recherche d'objets de donn\u00e9es applicatives");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
    }

    private static void executeOperationP11Empreintes(Application application, Saisie saisie) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        switch (saisie.getType()) {
            case 6: {
                if (application.getSessionCourante() != null && ((SaisieMessage)saisie).getMessage() != null && ((SaisieMessage)saisie).getAlgo() != null) {
                    resultat = GenererEmpreinteMessage.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieMessage)saisie).getAlgo().getIdAlgo(), ((SaisieMessage)saisie).getMessage());
                    if (resultat == null) break;
                    application.declencheAffichageResultat(resultat);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de generation de l'empreinte de message");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 7: {
                if (application.getSessionCourante() != null && ((SaisieFichier)saisie).getFichier() != null && ((SaisieFichier)saisie).getAlgo() != null) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(new File(((SaisieFichier)saisie).getFichier()));
                        resultat = GenererEmpreinteFichier.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieFichier)saisie).getAlgo().getIdAlgo(), fileInputStream);
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (resultat == null) break;
                        application.declencheAffichageResultat(resultat);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)("Une erreur fichier est survenue lors de la tentative de generation de l'empreinte de fichier : " + ExceptionProgrammeExemple.getStacktrace(fileNotFoundException)));
                        application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                    }
                    catch (IOException iOException) {
                        log.error((Object)("Une erreur fichier est survenue lors de la tentative de generation de l'empreinte de fichier : " + ExceptionProgrammeExemple.getStacktrace(iOException)));
                        application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                    }
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de generation de l'empreinte de fichier");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
    }

    private static void executeOperationP11Signatures(Application application, Saisie saisie) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        switch (saisie.getType()) {
            case 8: {
                if (application.getSessionCourante() != null && ((SaisieMessage)saisie).getMessage() != null && ((SaisieMessageSignature)saisie).getAlgo() != null && ((SaisieMessageSignature)saisie).getCle() != null) {
                    application.setMessageSigne(null);
                    application.setSignatureMessage(null);
                    resultat = GenererSignatureMessage.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieMessage)saisie).getAlgo().getIdAlgo(), ((SaisieMessageSignature)saisie).getCle().getIdCle(), ((SaisieMessage)saisie).getMessage());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat == null || resultat.getCodeRetourStr() == null || !resultat.getCodeRetourStr().startsWith("CKR_OK") || resultat == null || !((ResultatSignatureMessage)resultat).getCodeRetour2().startsWith("CKR_OK")) break;
                    application.setMessageSigne(((SaisieMessage)saisie).getMessage());
                    application.setSignatureMessage(((ResultatSignatureMessage)resultat).getSignature());
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de generation de la signature du message");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 9: {
                if (application.getSessionCourante() != null && ((SaisieFichier)saisie).getFichier() != null && ((SaisieFichierSignature)saisie).getAlgo() != null && ((SaisieFichierSignature)saisie).getCle() != null) {
                    FileInputStream fileInputStream = null;
                    try {
                        application.setFichierSigne(null);
                        application.setSignatureFichier(null);
                        fileInputStream = new FileInputStream(new File(((SaisieFichier)saisie).getFichier()));
                        resultat = GenererSignatureFichier.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieFichier)saisie).getAlgo().getIdAlgo(), ((SaisieFichierSignature)saisie).getCle().getIdCle(), fileInputStream);
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (resultat != null) {
                            application.declencheAffichageResultat(resultat);
                        }
                        if (resultat == null || resultat.getCodeRetourStr() == null || !resultat.getCodeRetourStr().startsWith("CKR_OK") || resultat == null || !((ResultatSignatureFichier)resultat).getCodeRetour2().startsWith("CKR_OK") || !((ResultatSignatureFichier)resultat).getCodeRetour3().startsWith("CKR_OK")) break;
                        application.setFichierSigne(((SaisieFichier)saisie).getFichier());
                        application.setSignatureFichier(((ResultatSignatureFichier)resultat).getSignature());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)("Une erreur fichier est survenue lors de la tentative de generation de la signature du fichier : " + ExceptionProgrammeExemple.getStacktrace(fileNotFoundException)));
                        application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                    }
                    catch (IOException iOException) {
                        log.error((Object)("Une erreur fichier est survenue lors de la tentative de generation de la signature du fichier : " + ExceptionProgrammeExemple.getStacktrace(iOException)));
                        application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                    }
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de generation de la signature du fichier");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
    }

    private static void executeOperationP11Verifications(Application application, Saisie saisie) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        switch (saisie.getType()) {
            case 10: {
                if (application.getSessionCourante() != null && ((SaisieMessage)saisie).getMessage() != null && ((SaisieMessageSignature)saisie).getAlgo() != null && ((SaisieMessageSignature)saisie).getSignature() != null && ((SaisieMessageSignature)saisie).getCle() != null) {
                    resultat = VerifierSignatureMessage.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieMessage)saisie).getAlgo().getIdAlgo(), ((SaisieMessageSignature)saisie).getCle().getIdCle(), ((SaisieMessage)saisie).getMessage(), ((SaisieMessageSignature)saisie).getSignature());
                    if (resultat == null) break;
                    application.declencheAffichageResultat(resultat);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de verification de la signature du message");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            case 11: {
                if (application.getSessionCourante() != null && ((SaisieFichier)saisie).getFichier() != null && ((SaisieFichierSignature)saisie).getAlgo() != null && ((SaisieFichierSignature)saisie).getSignature() != null && ((SaisieFichierSignature)saisie).getCle() != null) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(new File(((SaisieFichier)saisie).getFichier()));
                        resultat = VerifierSignatureFichier.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieFichier)saisie).getAlgo().getIdAlgo(), ((SaisieFichierSignature)saisie).getCle().getIdCle(), fileInputStream, ((SaisieFichierSignature)saisie).getSignature());
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (resultat == null) break;
                        application.declencheAffichageResultat(resultat);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)("Une erreur fichier est survenue lors de la tentative de verification de la signature du fichier : " + ExceptionProgrammeExemple.getStacktrace(fileNotFoundException)));
                        application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                    }
                    catch (IOException iOException) {
                        log.error((Object)("Une erreur fichier est survenue lors de la tentative de verification de la signature du fichier : " + ExceptionProgrammeExemple.getStacktrace(iOException)));
                        application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                    }
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de verification de la signature du fichier");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
    }

    private static void executeOperationP11GenerationAleatoire(Application application, Saisie saisie) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        switch (saisie.getType()) {
            case 5: {
                if (application.getSessionCourante() != null && ((SaisieSeed)saisie).getSeed() != null) {
                    resultat = GenerationSeed.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), ((SaisieSeed)saisie).getSeed());
                    if (resultat == null) break;
                    application.declencheAffichageResultat(resultat);
                    break;
                }
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative de generation de nombre pseudo-aleatoire coupl\u00e9e \u00e0 une graine (seed)");
                application.notifieException(new ExceptionControleur(302, "Une erreur inattendue est survenue"));
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
    }

    private static Vector<String> valideSaisieP11Sessions(Application application, Saisie saisie) throws ExceptionControleur {
        Vector<String> vector = new Vector<String>();
        switch (saisie.getType()) {
            case 3: {
                if (((Saisie2PIN)saisie).getPIN() == null || ((Saisie2PIN)saisie).getPIN().length == 0 || ((Saisie2PIN)saisie).getPIN2() == null || ((Saisie2PIN)saisie).getPIN2().length == 0) {
                    vector.add("Les 2 codes PIN doivent \u00eatre renseign\u00e9s");
                }
                if (((Saisie2PIN)saisie).getPIN() == null || new String(((Saisie2PIN)saisie).getPIN()).equalsIgnoreCase(new String(((Saisie2PIN)saisie).getPIN2()))) break;
                vector.add("Les 2 codes PIN doivent \u00eatre identiques");
                break;
            }
            case 4: {
                if (((Saisie3PIN)saisie).getPIN() == null || ((Saisie3PIN)saisie).getPIN().length == 0 || ((Saisie3PIN)saisie).getPIN2() == null || ((Saisie3PIN)saisie).getPIN2().length == 0 || ((Saisie3PIN)saisie).getPIN3() == null || ((Saisie3PIN)saisie).getPIN3().length == 0) {
                    vector.add("Les 3 codes PIN doivent \u00eatre renseign\u00e9s");
                }
                if (((Saisie3PIN)saisie).getPIN2() == null || new String(((Saisie3PIN)saisie).getPIN2()).equalsIgnoreCase(new String(((Saisie3PIN)saisie).getPIN3()))) break;
                vector.add("Les 2 nouveaux codes PIN doivent \u00eatre identiques");
                break;
            }
            case 2: {
                if (((Saisie1PIN)saisie).getPIN() != null && ((Saisie1PIN)saisie).getPIN().length != 0) break;
                vector.add("Le code PIN doit \u00eatre renseign\u00e9");
                break;
            }
            case 1: {
                if (((Saisie1PIN)saisie).getPIN() != null && ((Saisie1PIN)saisie).getPIN().length != 0) break;
                vector.add("Le code PUK doit \u00eatre renseign\u00e9");
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
        return vector;
    }

    private static Vector<String> valideSaisieP11Objets(Application application, Saisie saisie) throws ExceptionControleur {
        Vector<String> vector = new Vector<String>();
        switch (saisie.getType()) {
            case 12: 
            case 13: {
                if (((SaisieObjet)saisie).getLibelleObjet() == null || ((SaisieObjet)saisie).getLibelleObjet().length() == 0) {
                    vector.add("Le libell\u00e9 de l'objet doit \u00eatre renseign\u00e9");
                }
                if (((SaisieObjet)saisie).getObjet() != null && ((SaisieObjet)saisie).getObjet().length() != 0) break;
                vector.add("Les donn\u00e9es de l'objet doivent \u00eatre renseign\u00e9es");
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
        return vector;
    }

    private static Vector<String> valideSaisieP11Empreintes(Application application, Saisie saisie) throws ExceptionTraitement, ExceptionControleur {
        Vector<String> vector = new Vector<String>();
        switch (saisie.getType()) {
            case 6: {
                if (((SaisieMessage)saisie).getAlgo() == null) {
                    vector.add("Un algorithme doit \u00eatre s\u00e9lectionn\u00e9");
                }
                if (((SaisieMessage)saisie).getMessage() != null && ((SaisieMessage)saisie).getMessage().length != 0) break;
                vector.add("Le message doit \u00eatre renseign\u00e9");
                break;
            }
            case 7: {
                if (((SaisieFichier)saisie).getAlgo() == null) {
                    vector.add("Un algorithme doit \u00eatre s\u00e9lectionn\u00e9");
                }
                if (((SaisieFichier)saisie).getFichier() != null && ((SaisieFichier)saisie).getFichier().length() != 0) break;
                vector.add("Un fichier doit \u00eatre choisi");
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
        return vector;
    }

    private static Vector<String> valideSaisieP11Signatures(Application application, Saisie saisie) throws ExceptionTraitement, ExceptionControleur {
        Vector<String> vector = new Vector<String>();
        switch (saisie.getType()) {
            case 8: {
                if (((SaisieMessageSignature)saisie).getAlgo() == null) {
                    vector.add("Un algorithme doit \u00eatre s\u00e9lectionn\u00e9");
                }
                if (((SaisieMessageSignature)saisie).getMessage() == null || ((SaisieMessageSignature)saisie).getMessage().length == 0) {
                    vector.add("Le message doit \u00eatre renseign\u00e9");
                }
                if (((SaisieMessageSignature)saisie).getCle() != null) break;
                vector.add("Une cl\u00e9 doit \u00eatre s\u00e9lectionn\u00e9e");
                break;
            }
            case 9: {
                if (((SaisieFichierSignature)saisie).getAlgo() == null) {
                    vector.add("Un algorithme doit \u00eatre s\u00e9lectionn\u00e9");
                }
                if (((SaisieFichierSignature)saisie).getFichier() == null || ((SaisieFichierSignature)saisie).getFichier().length() == 0) {
                    vector.add("Un fichier doit \u00eatre choisi");
                }
                if (((SaisieFichierSignature)saisie).getCle() != null) break;
                vector.add("Une cl\u00e9 doit \u00eatre s\u00e9lectionn\u00e9e");
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
        return vector;
    }

    private static Vector<String> valideSaisieP11Verifications(Application application, Saisie saisie) throws ExceptionControleur {
        Vector<String> vector = new Vector<String>();
        switch (saisie.getType()) {
            case 10: {
                if (((SaisieMessageSignature)saisie).getAlgo() == null) {
                    vector.add("Un algorithme doit \u00eatre s\u00e9lectionn\u00e9");
                }
                if (((SaisieMessageSignature)saisie).getMessage() == null || ((SaisieMessageSignature)saisie).getMessage().length == 0) {
                    vector.add("Le message doit \u00eatre renseign\u00e9");
                }
                if (((SaisieMessageSignature)saisie).getSignature() == null || ((SaisieMessageSignature)saisie).getSignature().length() == 0) {
                    vector.add("La signature doit \u00eatre renseign\u00e9e");
                }
                if (((SaisieMessageSignature)saisie).getCle() != null) break;
                vector.add("Une cl\u00e9 doit \u00eatre s\u00e9lectionn\u00e9e");
                break;
            }
            case 11: {
                if (((SaisieFichierSignature)saisie).getAlgo() == null) {
                    vector.add("Un algorithme doit \u00eatre s\u00e9lectionn\u00e9");
                }
                if (((SaisieFichierSignature)saisie).getFichier() == null || ((SaisieFichierSignature)saisie).getFichier().length() == 0) {
                    vector.add("Un fichier doit \u00eatre choisi");
                }
                if (((SaisieFichierSignature)saisie).getSignature() == null || ((SaisieFichierSignature)saisie).getSignature().length() == 0) {
                    vector.add("La signature doit \u00eatre renseign\u00e9e");
                }
                if (((SaisieFichierSignature)saisie).getCle() != null) break;
                vector.add("Une cl\u00e9 doit \u00eatre s\u00e9lectionn\u00e9e");
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
        return vector;
    }

    private static Vector<String> valideSaisieP11GenerationAleatoire(Application application, Saisie saisie) throws ExceptionTraitement, ExceptionControleur {
        Vector<String> vector = new Vector<String>();
        switch (saisie.getType()) {
            case 5: {
                if (((SaisieSeed)saisie).getSeed() != null && ((SaisieSeed)saisie).getSeed().length != 0) break;
                vector.add("La graine (seed) doit \u00eatre renseign\u00e9e");
                break;
            }
            default: {
                log.error((Object)"Type d'\u00e9cran inconnu");
                throw new ExceptionControleur(302, "Une erreur inattendue est survenue");
            }
        }
        return vector;
    }
}

